<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 *
 * @author          LEPTON Project
 * @copyright       2010-2018 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */
 
// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

require_once (LEPTON_PATH.'/framework/summary.addon_precheck.php');

// create Admin object with admin header
// check user permissions for admintools (redirect users with wrong permissions)
$admin = new LEPTON_admin('Admintools', 'admintools', true);
$msg = array();
$error_msg = array();
$backlink = 'index.php?advanced=yes';
if ($admin->get_permission('admintools') == true)
{

/*'reload_all', not yet*/
    $post_check = array('reload_modules', 'reload_templates', 'reload_languages');

    /**
    * check if there is anything to do
    */
    foreach ($post_check as $index => $key)
    {
        if (!isset ($_POST[$key]) && !isset ($_POST['reload_all']))
        {
            unset ($post_check[$index]);
        }
    }
    if (count($post_check) == 0)
    {
        $error_msg[] = '<span class="normal bold red">'.$MESSAGE['GENERIC_PLEASE_CHECK_BACK_SOON'].'</span>';
    }
    else
    {

    /**
    * check if user has permissions to access this file
    */
    // include  configuration file and class.admin 
    // check if the referer URL if available
        $referer = isset ($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : (isset ($HTTP_SERVER_VARS['HTTP_REFERER']) ? $HTTP_SERVER_VARS['HTTP_REFERER'] : '');
        // if referer is set, check if script was invoked from "admin/modules/index.php"
        $required_url = ADMIN_URL.'/addons/index.php';
        if ($referer != '' && (!(strpos($referer, $required_url) !== false)))
        {
        // die( header('Location: ../../index.php'));
            $error_msg[] = '<span class="normal bold red">'.$MESSAGE['GENERIC_BAD_PERMISSIONS'].'</span>';
        }
        else
        {
        	// include functions file
            require_once (LEPTON_PATH.'/framework/summary.functions.php');
            // load language file
            require_once (LEPTON_PATH.'/languages/'.LANGUAGE.'.php');

            /**
            * Reload all specified Addons
            */
            $table = TABLE_PREFIX.'addons';
            foreach ($post_check as $key)
            {
                switch ($key) :
                    case 'reload_all' :
                    case 'reload_modules' :
                        // first remove addons entrys for module that don't exists
						$all_modules = array();
						$database->execute_query("SELECT directory FROM ".TABLE_PREFIX."addons WHERE type = 'module' ",
						true,
						$all_modules,
						true
						);
						
                        foreach ($all_modules as $value)     {
							
							if(file_exists(LEPTON_PATH.'/modules/'.$value['directory']))
							{
								continue; // check next module
                               }
							   
							$temp_info = array();
							$database->execute_query("SELECT * FROM ".TABLE_PREFIX."sections WHERE module = ".$value['directory']." ",
							true,
							$temp_info,
							true
							);
								
                            if(count($temp_info) > 0)
                            {
                             //	Module is in use, so we have to warn the user

                                foreach ($temp_info as $data)
                                    {
                                    $temp_title = $database->get_one("SELECT menue_title FROM ".TABLE_PREFIX."pages WHERE page_id = ".$data['page_id']." ");
									$page_url = '<span class="normal bold"> -> <a href="'.ADMIN_URL.'/pages/sections.php?page_id='.$data['page_id'].'">'.$temp_title.'</a> ('.$TEXT['PAGE'].' '.$data['page_id'].')</span>';
                                    $error_msg[] = '<span class="normal bold">'.$data['module'].'</span> <span class="normal bold red">'.$MESSAGE['GENERIC_MODULE_VERSION_ERROR'].'</span>'.$page_url;
                                }
                            }
                            else
                            {
								// addon in addons_table but not in use and physically deleted: delete entry in addons table
								$database->simple_query("DELETE from ".TABLE_PREFIX."addons WHERE type = 'module' AND directory = ".$value['directory']." ");
                            }
                        }

                        //	Now compare modules folder with entries in addons
                        $modules = scan_current_dir(LEPTON_PATH.'/modules');
                        if (count($modules['path']) > 0)
                        {
                            foreach ($modules['path'] as &$value)
							{

								// Test for missing entries in the DB.
								$temp_info = array();
								$database->execute_query(
									"SELECT * FROM `".TABLE_PREFIX."addons` WHERE `directory`='".$value."'",
									true,
									$temp_info,
									false
								);

								if(count($temp_info) === 0) {
									
									// There is no entry for this module in the DB!
									require(LEPTON_PATH.'/modules/'.$value."/info.php");
									// if disabled addons exist
									if($module_directory != $value) {
										continue;
									} else {
										load_module(LEPTON_PATH.'/modules/'.$value,true);
										$msg[] = '<span class="normal bold green">'.$value.' :: '.$MESSAGE['GENERIC_INSTALLED'].'</span>';										
									}

								} else {

									$code_version = get_modul_version($value);
									$db_version = $temp_info['version'];

									if (($db_version != null) && ($code_version != null))
									{
										if (versioncompare($db_version, $code_version, '>'))
										{
										    $error_msg[] = '<span class="normal bold red">'.$value.' ( '.$db_version.' > '.$code_version.' ) '.$MESSAGE['GENERIC_MODULE_VERSION_ERROR'].'</span>';
										    continue;
										}
										else
										{
											require(LEPTON_PATH.'/modules/'.$value."/info.php");
										    load_module(LEPTON_PATH.'/modules/'.$value);
										    $msg[] = '<span class="normal bold green">'.$value.' :: '.$MESSAGE['ADDON_MODULES_RELOADED'].'</span>';
										}
									}
								}
							}
						}
						else
						{
							$error_msg[] = '<span class="normal bold red">'.$MESSAGE['ADDON_ERROR_RELOAD'].'</span>';
						}
						break;

                    case 'reload_templates' :
                    	$templates = scan_current_dir(LEPTON_PATH.'/templates');
                        if (count($templates['path']) > 0)
                        {
                        	// Delete templates from database
                            $sql = 'DELETE FROM  `'.TABLE_PREFIX.'addons`  WHERE `type` = \'template\'';
                            $database->query($sql);
                            
                            // Reload all templates
                            foreach($templates['path'] as &$file)
                            {
								require(LEPTON_PATH.'/templates/'.$file."/info.php");
								load_template(LEPTON_PATH.'/templates/'.$file);
                            }
                            // Add success message
                            $msg[] = '<span class="normal bold green">'.$MESSAGE['ADDON_TEMPLATES_RELOADED'].'</span>';
                        }
                        else
                        {
                        	// Add error message
                            $error_msg[] = '<span class="normal bold red">'.$MESSAGE['ADDON_ERROR_RELOAD'].' - No templates found!</span> ';
                        }
                        break;

                    case 'reload_languages' :
                        $languages = scan_current_dir(LEPTON_PATH.'/languages/', 'php');
                        if ( count($languages['filename']) > 0)
                        {
                        	// Delete languages from database
                            $sql = 'DELETE FROM  `'.TABLE_PREFIX.'addons`  WHERE `type` = \'language\'';
                            $database->query($sql);
                            
                            // Reload all languages
                            foreach($languages['filename'] as &$file)
                            {
								load_language(LEPTON_PATH.'/languages/'.$file);
                            }
                            
                            //  Reload the current language file - otherwise wie've got the last message in e.g. russian.
                        	require( LEPTON_PATH . '/languages/' . LANGUAGE . '.php' );    
                        	
                            // Add success message
                            $msg[] = '<span class="normal bold green">'.$MESSAGE['ADDON_LANGUAGES_RELOADED'].'</span>';
                        }
                        else
                        {
                        	// Add error message
                            $error_msg[] = '<span class="normal bold red">'.$MESSAGE['ADDON_ERROR_RELOAD'].' - No languages found!</span>';
                        }
                        break;
                    endswitch;
            }
        }
    }
}
else
{
    $error_msg[] = '<span class="big bold red">'.$MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES'].'</span> ';
}
//
if (sizeof($error_msg) > 0)
{
    $error_msg = array_merge($error_msg, $msg);
    $admin->print_error( implode($error_msg, '<br />'), $backlink );
}
else
{
// output success message
    $admin->print_success( implode($msg, '<br />'), $backlink );
}
// $admin->print_footer();

?>