<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2018 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php


// prevent users to access url directly
if(!in_array('groups',$_SESSION['SYSTEM_PERMISSIONS']))  {
	header("Location: ".ADMIN_URL."");
	exit(0);
}

// enable custom files, start with index file (not in LEPsem BE-THEME)
//LEPTON_handle::require_alternative('/templates/'.DEFAULT_THEME.'/backend/backend/groups/index.php');
if(file_exists(THEME_PATH .'/backend/backend/groups/index.php')) {
	require_once (THEME_PATH .'/backend/backend/groups/index.php');
	die();
}

// get twig instance
$admin = LEPTON_admin::getInstance();
$oTWIG = lib_twig_box::getInstance();

//	As we are "calling" a static method more than two times we are using an instance here for the reference for the class
$LEPTON_basics = LEPTON_basics::getInstance();

//	temp. hack to get page to run	
if (!isset($_POST['action'])) $_POST['action'] = "modify";

if($_POST['action'] == 'modify')
{

	/**
	 *	Get all groups for the groups-tree left
	 *	exept the group 1 (Administrators)!
	 *
	 */
	$all_groups = array();
	$database->execute_query(
		"SELECT `group_id`,`name` from `". TABLE_PREFIX."groups` WHERE `group_id` <> 1",
		true,
		$all_groups,
		true
	);
	
	if (!isset($_POST['group_id']) || ($_POST['group_id'] == 1) ) {
		
		$group = array(
			'group_id'	=> -1,
			'name'	=> "",
			'system_permissions' => "",
			'module_permissions' => "",
			'template_permissions' => "",
			'language_permissions' => ""			
		);
		
	} else {
	
		// Get group values
		$group = array();
		$database->execute_query(
			"SELECT * FROM `".TABLE_PREFIX."groups` WHERE `group_id` = '".intval($_POST['group_id'])."'",
			true,
			$group,
			false
		);
	}
	
	/**	**************************
	 *	Get the system permissions/languages
	 */
	$system_lookups = array(
		'pages'		=> array('view', 'add', 'add_level_0','settings', 'modify','delete'),
		'media'		=> array('view','upload','rename','delete','create'),
		'modules'	=> array('view','install','uninstall'),
		'templates' => array('view','install','uninstall'),
		'languages' => array('view','install','uninstall'),
		'settings'	=> array('advanced'),
		'users'		=> array('view','add','modify','delete'),
		'groups'	=> array('view','add','modify','delete'),
		'admintools' => array('view')
	);
	
	$group_system_permissions = explode(',', $group['system_permissions']);
	
	$system_permissions = array();
	
	foreach($system_lookups as $sys_key => $subkeys) {
		
		$sub_keys = array();
		
		foreach($subkeys as $item) {
			$sub_keys[] = array(
				'name' => $sys_key."_".$item,
				'label'	=> $LEPTON_basics->get_backend_translation( strtoupper($item) ),
				'checked' => in_array( $sys_key."_".$item, $group_system_permissions ) ? 1 : 0
			);
		}
		
		$system_permissions[] = array(
			'name'	=> $sys_key,
			'label'	=> $MENU[ (strtoupper($sys_key)) ],
			'checked' => in_array( $sys_key, $group_system_permissions ) ? 1 : 0,
			'sub_keys'	=> $sub_keys
		);
	}
	
	/**	**************************
	 *	Get the module permissions
	 */
	$all_modules = array();
	$database->execute_query(
		'SELECT `name`,`directory` FROM `'.TABLE_PREFIX.'addons` WHERE `type` = "module" AND `function` = "page" ORDER BY `name`',
		true,
		$all_modules,
		true
	);
	
	$group_module_permissions = explode(',', $group['module_permissions']);
	
	$module_permissions = array();
	foreach($all_modules as &$module) {
		$module_permissions[] = array(
			'name'	=> $module['name'],
			'directory' => $module['directory'],
			'permission' => in_array($module['directory'], $group_module_permissions) ? 1 : 0
		);
	}
	
	/**	*******************************
	 *	Get the admin-tools permissions
	 */
	$all_tools = array();
	
	$database->execute_query(
		'SELECT `name`,`directory` FROM `'.TABLE_PREFIX.'addons` WHERE `type` = "module" AND `function` = "tool" ORDER BY `name`',
		true,
		$all_tools,
		true
	);
	
	$admintools_permissions = array();
	foreach($all_tools as &$tool) {
		$admintools_permissions[] = array(
			'name'	=> $tool['name'],
			'directory' => $tool['directory'],
			'permission' => in_array($tool['directory'], $group_module_permissions) ? 1 : 0
		);
	}
	
	/**	*****************************
	 *	Get the templates permissions
	 */
	$all_templates = array();
	$database->execute_query(
		'SELECT `name`,`directory` FROM `'.TABLE_PREFIX.'addons` WHERE `type` = "template" ORDER BY `name`',
		true,
		$all_templates,
		true
	);
	
	$group_template_permissions = explode(',', $group['template_permissions']);
	
	$template_permissions = array();
	foreach($all_templates as &$template) {
		$template_permissions[] = array(
			'name'	=> $template['name'],
			'directory' => $template['directory'],
			'permission' => in_array($template['directory'], $group_template_permissions) ? 1 : 0
		);
	}
	
	/**	*****************************
	 *	Get the language permissions
	 */
	$all_languages = array();
	$database->execute_query(
		'SELECT `name`,`directory` FROM `'.TABLE_PREFIX.'addons` WHERE `type` = "language" ORDER BY `name`',
		true,
		$all_languages,
		true
	);
	
	$group_language_permissions = explode(',', $group['language_permissions']);

	$language_permissions = array();
	foreach($all_languages as &$language) {
		$language_permissions[] = array(
			'name'	=> $language['name'],
			'directory' => $language['directory'],
			'permission' => in_array($language['directory'], $group_language_permissions) ? 1 : 0
		);
	}	
//die(print_r($language_permissions));		
	/**
	 *	Get/Build secure-hash for the js-calls
	 */
	if(!function_exists("random_string")) require_once( LEPTON_PATH."/framework/functions/function.random_string.php");
	$hash = array(
		'h_name' => random_string(16),
		'h_value' => random_string(24)
	);
	$_SESSION['backend_group_h'] = $hash['h_name'];
	$_SESSION['backend_group_v'] = $hash['h_value'];

	$page_values = array(
		'THEME' => $THEME,
		'all_groups' => $all_groups,
		'group' => $group,
		'ACTION_URL' => ADMIN_URL.'/groups/save.php',
		'system_permissions' => $system_permissions,
		'module_permissions' => $module_permissions,
		'admintools_permissions' => $admintools_permissions,
		'template_permissions'	=> $template_permissions,
		'language_permissions'	=> $language_permissions,		
		'hash'	=> $hash,
		'FORM_NAME' => "groups_".random_string(12)
	);
	
    if(isset($_SESSION['last_saved_group_id']))
    {
        $page_values['last_saved_group_id'] = $_SESSION['last_saved_group_id'];
        unset( $_SESSION['last_saved_group_id'] );
    } else {
        $page_values['last_saved_group_id'] =$all_groups[0]['group_id']; //0;
    }

	$oTWIG->registerPath( THEME_PATH."theme","groups" );
	echo $oTWIG->render(
		"@theme/groups.lte",
		$page_values
	);

} elseif($_POST['action'] == 'delete') {
	// Create new LEPTON_admin object
	$admin = new LEPTON_admin('Access', 'groups_delete', false);
	// Print header
	$admin->print_header();
	// Delete the group
	$database->query("DELETE FROM ".TABLE_PREFIX."groups WHERE group_id = '".$_POST['group_id']."' LIMIT 1");
	if($database->is_error())
	{
		$admin->print_error($database->get_error());
	} else {
		// Delete users in the group
		$database->query("DELETE FROM ".TABLE_PREFIX."users WHERE group_id = '".$_POST['group_id']."'");
		if($database->is_error()) {
			$admin->print_error($database->get_error());
		} else {
			$admin->print_success($MESSAGE['GROUPS_DELETED']);
		}
	}
}

// Print admin footer
$admin->print_footer();

?>