<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 *
 * @author          LEPTON Project
 * @copyright       2010-2018 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

/**
 * check if there is anything to do
 */

$leptoken = (isset($_GET['leptoken'])) ? "?leptoken=".$_GET['leptoken'] : "";
$backlink = "../modules/index.php".$leptoken;

if (!(isset($_POST['action']) && in_array($_POST['action'], array('install', 'upgrade')))) { 
	die(header('Location: '.$backlink));
}
if (!(isset($_POST['file']) && $_POST['file'] != '')) {
	die(header('Location: '.backlink));
}

/**
 * check if user has permissions to access this file
 */
// check user permissions for admintools (redirect users with wrong permissions)
$admin = new LEPTON_admin('Admintools', 'admintools', false, false);
if ($admin->get_permission('admintools') == false) {
	die(header('Location: ../../index.php'));
}

// create Admin object with admin header
$admin = new LEPTON_admin('Addons', '', true, false);
$js_back = ADMIN_URL . '/modules/index.php'.$leptoken;

/**
 * Manually execute the specified module file (install.php, upgrade.php)
 * Keep in mind that $_POST['file'] contains the whole path! 
 */
$module_file = trim( $_POST['file'] );

if (!file_exists($module_file))
{
    $admin->print_error($TEXT['NOT_FOUND'].': <tt>"'.$module_file.'"</tt> ', $js_back);
}

// include modules install.php/upgrade.php script
require $module_file ;

// load module info into database and output status message
$mod_path = dirname($module_file);
require( $mod_path."/info.php");
if (!function_exists("load_module")) require_once(LEPTON_PATH."/framework/functions/function.load_module.php");
//load_module($mod_path, false);

// Finish installation
if ( $_POST['action'] == "install" )
{
	// Load module info into DB
	load_module(LEPTON_PATH.'/modules/'.$module_directory, false);
	  
	// let admin set access permissions for modules of type 'page' and 'tool'
	if ( $module_function == 'page' || $module_function == 'tool' )
	{
		// get groups
		$all_groups = array();
		$database->execute_query(
			"SELECT * FROM `".TABLE_PREFIX."groups`WHERE group_id <> 1",
   	  		true,
   	  		$all_groups,
   	  		true
   		);
   	
    	$oTwig = lib_twig_box::getInstance();
   	
    	echo $oTwig->render(
    		"@theme/set_group_permissions.lte",
    		array(
    			'action_url'	=> ADMIN_URL."/modules/save_permissions.php",
    			'all_groups'	=> $all_groups,
    			'MESSAGE'	=> $MESSAGE,
    			'TEXT'		=> $TEXT,
    			'module_directory' => $module_directory
    		)
    	);

		$admin->print_footer();
		exit();
	}
}

$msg = $TEXT['EXECUTE'] . ': <tt>"' . htmlentities(basename($mod_path)) . '/' . $_POST['action'] . '.php"</tt>';

switch ($_POST['action'])
{
	case 'install':
	case 'upgrade':
		$admin->print_success($msg, $js_back);
		break;
		
	default:
		$admin->print_error( $TEXT["ACTION_NOT_SUPPORTED"], $js_back);
}

?>