<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          wysiwyg
 * @author          Ryan Djurovich
 * @author          LEPTON Project
 * @copyright       2004-2010 WebsiteBaker Project
 * @copyright       2010-2018 LEPTON Project 
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

/**
 *	Get section content
 *
 */
$data = array();
$database->execute_query(
    "SELECT `content` FROM `".TABLE_PREFIX."mod_wysiwyg` WHERE `section_id`= '".$section_id."'",
    true,
    $data,
    false
);
$content = $data['content'];

/**
 *	Try to add an \ before the "$" char.
 */
$content = str_replace("\$", "\\\$", $content);

$oWYSIWYG = wysiwyg::getInstance();

if (isset($preview) && $preview == true)
{
    return false;
}

/**
 *  Get wysiwyg-editor content, incl. js.
 */
ob_start();
show_wysiwyg_editor(
    "content".$section_id,
    "content".$section_id,
    $content,
    '100%',
    '250px',
    true
);
$wysiwyg_editor_content = ob_get_clean();

/**
 *  Collect the values
 */
$form_values = array(
	'LEPTON_URL'	=> LEPTON_URL,
	'page_id'		=> $page_id,
	'section_id'	=> $section_id,
	'TEXT'			=> $TEXT,
	'wysiwyg_editor' => $wysiwyg_editor_content
);

// Get instance of the template engine and render the output
$oTWIG = lib_twig_box::getInstance();
$oTWIG->registerModule("wysiwyg");

echo $oTWIG->render( 
	"@wysiwyg/modify.lte", // template-filename
	$form_values	//	template-data
);
	
?>