<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2019 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);

echo ('<h3>Current process: updating to LEPTON 4.4.0</h3>');

// [1] modify lepton.ini
echo ('<h5>Current process : modify lepton.ini</h5>');	
$filename = LEPTON_PATH.'/config/lepton.ini.php';

$aTempConfig = parse_ini_string(";".file_get_contents($filename), true );

$sIniAddition = "";
if(!isset($aTempConfig['custom_vars']))
{
    // [1.1] The comlete key/chapter is missing
    $sIniAddition = "

; Set allowed additional chars for email and usernames (extends LEPTON_handle methods) 
[custom_vars]
additional_email_chars = ''
additional_usernames_chars = 'äöüÄÖÜ' 

";
} else {
    // [1.2] The key/chapter is there - so we have to look for the basic values
    
    // [1.2.1] additional_email_chars
    if(!isset($aTempConfig['custom_vars']['additional_email_chars']))
    {
       $sIniAddition .= "
additional_email_chars = ''";
        echo("<p>Add missing key for <strong>additional_email_chars</strong>.</p>"); 
    }
    
    // [1.2.2] additional_usernames_chars
    if(!isset($aTempConfig['custom_vars']['additional_usernames_chars']))
    {
       $sIniAddition .= "
additional_usernames_chars = 'äöüÄÖÜ'";
        echo("<p>Add missing key for <strong>additional_usernames_chars</strong>.</p>");
    }
}

// [1.3] Update the file
if ( (strlen($sIniAddition) > 0 ) && ( is_writable($filename) ) )
{
    if (!$handle = fopen($filename, "a")) // append
    {
        echo('Cannot open file'); 
    }

    if (!fwrite($handle, $sIniAddition)) {
         echo('Cannot write into file'); 
    }

    fclose($handle);
	echo ('<h5>Current process : modify lepton.ini successful</h5>');	

} else 
{
   echo ('<h5>Current process : modify lepton.ini failed!</h5>');	
}
// End of "update the ini-file

// [2] db changes
echo '<h5>Current process: add new log table</h5>';
	// [2.1] Test if table exists
	$aAllTables = $database->list_tables( TABLE_PREFIX );
	if(!in_array("log", $aAllTables))
	{
        $table_fields =" 
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `logged` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
              `user_id` int(11) NOT NULL DEFAULT '-1',
              `username` varchar(255) NOT NULL DEFAULT '',
              `action` varchar(255) NOT NULL DEFAULT '',
              `log_text` text NOT NULL,
              `comment` varchar(255) NOT NULL DEFAULT '',
              `check` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
              PRIMARY KEY (`id`)
            ";
        LEPTON_handle::install_table('log', $table_fields);
	}	
echo "<h5>add new log table: successfull</h5>";

// [3] delete lib_semantic 
if(file_exists(LEPTON_PATH.'/modules/lib_semantic/info.php'))
{
	LEPTON_handle::delete_obsolete_directories('/modules/lib_semantic');
	$database->simple_query( "DELETE FROM ".TABLE_PREFIX."addons WHERE directory = 'lib_semantic' ");	
	?>
	<div class="ui negative message">
		<h4>Current process : delete lib_semantic</h4>
		<p>Learn more about how to switch from <a href="https://doc.lepton-cms.org/docu/english/home/tutorials/lib_fomantic-replaces-lib_semantic.php" target="_blank"> lib_semantic to lib_fomantic</a></p>
		<h4>Delete delete lib_semantic: successful</h4>
	</div>
	<?php
}

// delete not needed template files lepton3
if(!file_exists(LEPTON_PATH.'/templates/lepton3/img/index.php'))
{
	echo '<h5>Current process: delete not needed template files lepton3</h5>';  

	LEPTON_handle::delete_obsolete_directories('/templates/lepton3');
	
	echo "<h5>delete not needed template files lepton3: successfull</h5>";
}

// delete not needed template files semantic
if(!file_exists(LEPTON_PATH.'/templates/semantic/img/index.php'))
{
	echo '<h5>Current process: delete not needed template files semantic</h5>';  

	LEPTON_handle::delete_obsolete_directories('/templates/semantic');
	
	echo "<h5>delete not needed template files semantic: successfull</h5>";
}
		 
$module_names = array(
	"cookie",
	"initial_page",
	"lib_fomantic",
	"lib_jquery",
	"lib_lepton",
	"lib_search",
	"lib_twig",
	"news",
	"tinymce",
	"wysiwyg"
);
LEPTON_handle::upgrade_modules($module_names);

echo "<h5>run upgrade.php of modified modules: successfull</h5>";


// update release and success message
echo ('<h5>Current process: set new release no</h5>');	
$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='4.4.0' WHERE name = 'lepton_version' ");
if($database->is_error()) {
	echo LEPTON_tools::display( $database->get_Error() , "div", "ui message red");
} else {
	echo "<h3>update to LEPTON 4.4.0 successfull!</h3><br />"; 
}

?>
