<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2020 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);

echo ('<h3>Current process: updating to LEPTON 4.5.0</h3>');

if(DEFAULT_THEME == 'algos')
{
	// switch theme
	echo '<h5>Current process: switch theme to LEPSem (new standard theme)</h5>';  
	LEPTON_handle::register('switch_theme');
	switch_theme('lepsem');

	echo(LEPTON_tools::display('Please keep in mind that you now have to login with '.LEPTON_URL.'/backend ', 'pre','ui red message'));
	echo(LEPTON_tools::display('You can switch to Algos (depricated!) or new Talgos via /options ', 'pre','ui blue message'));
	echo "<h5>Switch theme to LEPSem: successfull</h5>";
}

// delete not needed template files lepton3
if(!file_exists(LEPTON_PATH.'/templates/lepton3/img/index.php'))
{
	echo '<h5>Current process: delete not needed template files lepton3</h5>';  

	LEPTON_handle::delete_obsolete_directories('/templates/lepton3');
	
	echo "<h5>delete not needed template files lepton3: successfull</h5>";
}

// delete not needed template files semantic
if(!file_exists(LEPTON_PATH.'/templates/semantic/img/index.php'))
{
	echo '<h5>Current process: delete not needed template files semantic</h5>';  

	LEPTON_handle::delete_obsolete_directories('/templates/semantic');
	
	echo "<h5>delete not needed template files semantic: successfull</h5>";
}

// upgrade updated modules
echo '<h5>Current process: run modules upgrade.php</h5>';  
		 
$module_names = array(
	"code2",
	"droplets",
	"edit_area",
	"initial_page",
	"jsadmin",
	"lib_fomantic",
	"lib_jquery",
	"lib_lepton",
	"lib_phpmailer",
	"lib_r_filemanager",
	"lib_search",
	"lib_twig",
	"menu_link",
	"news",
	"quickform",
	"show_menu2",
	"tinymce",
	"wysiwyg",
	"wysiwyg_admin"
);
LEPTON_handle::upgrade_modules($module_names);

echo "<h5>run upgrade.php of modified modules: successfull</h5>";


// update release and success message
echo ('<h5>Current process: set new release number</h5>');	
$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='4.5.0' WHERE name = 'lepton_version' ");
if($database->is_error()) {
	echo LEPTON_tools::display( $database->get_Error() , "div", "ui message red");
} else {
	echo "<h3>update to LEPTON 4.5.0 successfull!</h3><br />"; 
}

?>
