<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2020 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);

echo ('<h3>Current process: updating to LEPTON 4.6.0</h3>');

if(DEFAULT_THEME == 'algos')
{
	// switch theme
	echo '<h5>Current process: switch theme to LEPSem (new standard theme)</h5>';  
	LEPTON_handle::register('switch_theme');
	switch_theme('lepsem');

	echo(LEPTON_tools::display('Please keep in mind that you now have to login with '.LEPTON_URL.'/backend ', 'pre','ui red message'));
	echo(LEPTON_tools::display('You can switch to Algos (depricated!) or new Talgos via /options ', 'pre','ui blue message'));
	echo "<h5>Switch theme to LEPSem: successfull</h5>";
}

// delete not needed template files lepton3
if(!file_exists(LEPTON_PATH.'/templates/lepton3/img/index.php'))
{
	echo '<h5>Current process: delete not needed template files lepton3</h5>';  

	LEPTON_handle::delete_obsolete_directories('/templates/lepton3');
	
	echo "<h5>delete not needed template files lepton3: successfull</h5>";
}

// delete not needed template files semantic
if(!file_exists(LEPTON_PATH.'/templates/semantic/img/index.php'))
{
	echo '<h5>Current process: delete not needed template files semantic</h5>';  

	LEPTON_handle::delete_obsolete_directories('/templates/semantic');
	
	echo "<h5>delete not needed template files semantic: successfull</h5>";
}

// [1] modify lepton.ini
echo ('<h5>Current process : modify lepton.ini</h5>');	
$filename = LEPTON_PATH.'/config/lepton.ini.php';

$aTempConfig = parse_ini_string(";".file_get_contents($filename), true );

$sIniAddition = "";
if(!isset($aTempConfig['system_const']))
{
    // [1.1] The complete key/chapter is missing
    $sIniAddition = "
	
; Set length for username and password
[system_const]
AUTH_MIN_LOGIN_LENGTH = 3
AUTH_MAX_LOGIN_LENGTH = 128
AUTH_MIN_PASS_LENGTH = 6
AUTH_MAX_PASS_LENGTH = 128
SUBVERSION = ''
MAX_REGISTRATION_TIME = 3600
MAX_WYSIWYG_HISTORY = 3
	
";
} else {
    // [1.2] The key/chapter is there - so we have to look for the basic values
    
    // [1.2.1] MAX_REGISTRATION_TIME
    if(!isset($aTempConfig['system_const']['MAX_REGISTRATION_TIME']))
    {
       $sIniAddition .= "
MAX_REGISTRATION_TIME = 3600
MAX_WYSIWYG_HISTORY = 3
";
        //  [1.2.1.2]
        $aTempConfig['system_const']['MAX_REGISTRATION_TIME'] = 3600;
		$aTempConfig['system_const']['MAX_WYSIWYG_HISTORY'] = 6;
        echo("<p>Add missing key for <strong>MAX_REGISTRATION_TIME</strong> and <strong>MAX_WYSIWYG_HISTORY</strong>.</p>"); 
    }
}

// [1.3] Update the file
if ( (strlen($sIniAddition) > 0 ) && ( is_writable($filename) ) )
{

    $s = ";
; <?php die(); ?>
; This file is part of LEPTON Core, released under the GNU GPL
; Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
;
; NOTICE:LEPTON CMS Package has several different licenses.
; Please see the individual license in the header of each single file or info.php of modules and templates.
;
; @author          LEPTON Project
; @copyright       2010-2020 LEPTON Project
; @link            https://www.LEPTON-cms.org
; @license         http://www.gnu.org/licenses/gpl.html
; @license_terms   please see LICENSE and COPYING files in your package
;
;

; DataBase-setup for LEPTON-CMS
;
;   Re-written by upgrade-script for L* 4.6.0
;
";

    foreach($aTempConfig as $ref => $subkeys)
    {
        $s .= "\n[".$ref."]\n";
    
        foreach($subkeys as $key => $value)
        {
            if(is_string($value))
            {
                $s .= $key ." = '".$value."'\n";
            } else {
                $s .= $key ." = ".$value."\n";
            }
        }
    }
    
    if (!$handle = fopen($filename, "w")) // NOT append!
    {
        echo('Cannot open file'); 
    }

    if (!fwrite($handle, $s)) {
         echo('Cannot write into file'); 
    }

    fclose($handle);
	echo ('<h5>Current process : re-write lepton.ini successful</h5>');	

} else 
{
   echo ('<h5>Current process : modify lepton.ini failed!</h5>');	
}
// End of "update the ini-file

// upgrade field login_ip: https://forum.lepton-cms.org/viewtopic.php?f=27&p=13323#p13323
$database->simple_query("ALTER TABLE ".TABLE_PREFIX."users CHANGE `login_ip` `login_ip` VARCHAR(64) NOT NULL DEFAULT '' ");

// upgrade updated modules
echo '<h5>Current process: run modules upgrade.php</h5>';  
		 
$module_names = array(
	"cookie",
	"droplets",
	"lib_lepton",
	"lib_search",
	"lib_r_filemanager",
	"news",
	"tinymce",
	"wysiwyg",	
	"wysiwyg_admin"
);
LEPTON_handle::upgrade_modules($module_names);

echo "<h5>run upgrade.php of modified modules: successfull</h5>";


// update release and success message
echo ('<h5>Current process: set new release number</h5>');	
$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='4.6.0' WHERE name = 'lepton_version' ");
echo "<h3>update to LEPTON 4.6.0 successfull!</h3><br />"; 
