<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2020 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

/**
 *  The LEPTON class for backward compatibility in addons
 *
 */
class LEPTON_xrun
{
    
    use LEPTON_secure_database;
    
    const DESCRIBE_RAW           = 0;
    const DESCRIBE_ASSOC         = 1;
    const DESCRIBE_ONLY_NAMES    = 2;
    
    /**
     *  Singleton The reference to *Singleton* instance of this class
     *  @var    object  $instance
     */
    private static $instance;
    
    
    /**
     *	Execute a SQL query and return a handle to queryMySQL
     *	
     *	@param	str     The query string to be executed
     *	@return	mixed   RESOURCE or NULL for error
     *
     */
    public function query( $sSqlQuery = "" )
    {
    	$this->error = "";
    	try{
		    $result = new queryMySQL( $this->db_handle );
    		return $result->query( $sSqlQuery );

		} catch( PDOException $error ) {
		    $this->set_error( $error->getMessage() );
		    return NULL;
		}
    }
}            

if(!class_exists('queryMySQL'))
{
	/**
	 *  "Old" core-class to store/hold the mySQL results
	 *	
	 */
	final class queryMySQL
	{
		/**
		 *	Internal storrage for the results.
		 *	Since we're using PDO this is type of PDOStatement(-object)!
		 *
		 */
		private $query_result = false;
		
		/**
		 *	Internal PDO handle.
		 *
		 */
		private $pdo = NULL;
		
		/**
		 *	Construtor of the class.
		 *
		 *	@param	object	A valid PDO Handle
		 *
		 */
		public function __construct( $pdo_handle )
		{
			$this->pdo = &$pdo_handle;
		}
		
		/**
		 *	Destructor of the class.
		 *
		 *	@notice	Free all 'Sub'-Objects.
		 *
		 */
		public function __destruct()
		{
			// if this class var is an object we've to call the __destruct method by our self
			if ($this->query_result != false) unset( $this->query_result );
		}
		
		/**
		 * Execute a MySQL query statement and return the resource or false on error
		 * 
		 * @param string	$SQL query
		 * @return object	This
		 *
		 */
		public function query($SQL)
		{
			$this->query_result = $this->pdo->query($SQL);
			return $this;
		}
		
		/**
		 * Return the number of rows of the query result
		 *
		 * @return INT	The number of rows of the last query result.
		 *
		 */
		public function numRows()
		{
			return $this->query_result->rowCount();
		}
		
		/**
		 *	Fetch a Row from the result array
		 * 
		 *	Specify $array_type you want to get back: PDO::FETCH_ASSOC, PDO::FETCH_NUM or PDO::FETCH_BOTH.
		 *	Since we're using PDO there are also PDO constants supported.
		 *	See http://www.php.net/manual/en/pdostatement.fetch.php for details.
		 *
		 *	This function return FALSE if there is no further row.
		 *
		 *	@param	INT		Typicaly a PHP Constant for the requestet type. Default is PDO::FETCH_ASSOC.
		 *	@return	ARRAY	The result-array or false if there is no further row.
		 *
		 */
		public function fetchRow($array_type = PDO::FETCH_ASSOC)
		{
			if (!in_array($array_type, array(PDO::FETCH_ASSOC, PDO::FETCH_NUM, PDO::FETCH_BOTH))) $array_type = PDO::FETCH_BOTH;
			
			return $this->query_result->fetch( $array_type );
		}
		
		/**
		 *	Public function to return all results of the query as
		 *	an assoc. array.
		 *
		 *	@param	string	The query-string to execute.
		 *	@return array	The results as assoc. array.
		 *
		 */
		public function fetchAll( $SQL ) {
			$this->query_result = $this->pdo->query($SQL);
			return $this->query_result->fetchAll( PDO::FETCH_ASSOC );
		}
	}
}
