<?php

/**
 * @module          Reset PIN
 * @author          cms-lab
 * @copyright       2019-2019 cms-lab
 * @link            http://www.cms-lab.com
 * @license         custom license: http://cms-lab.com/_documentation/reset-pin/license.php
 * @license_terms   please see license
 *
 */

class reset_pin extends LEPTON_abstract
{
	public $all_users = array();	
	public $database = 0;
	public $admin = 0;
	public $addon_color = 'blue';
	public $action_url = ADMIN_URL . '/admintools/tool.php?tool=reset_pin';	

	public static $instance;

	public function initialize() 
	{
		$this->database = LEPTON_database::getInstance();
		$this->admin = LEPTON_admin::getInstance();		
		$this->init_tool();
	}
	
	public function init_tool( $sToolname = '' )
	{

		//get all users
		$this->all_users = array();
		$this->database->execute_query(
			"SELECT * FROM ".TABLE_PREFIX."users " ,
			true,
			$this->all_users,
			true
		); 
				
	}
	
	public function set_pin() 
	{
		// data for twig template engine	
		$data = array(
			'oRP'			=> $this,
			'readme_link'	=> 'http://cms-lab.com/_documentation/reset-pin/readme.php',
			'leptoken'		=> get_leptoken()			
			);

		/**	
		 *	get the template-engine.
		 */
		$oTwig = lib_twig_box::getInstance();
		$oTwig->registerModule('reset_pin');
			
		echo $oTwig->render( 
			"@reset_pin/tool.lte",	//	template-filename
			$data						//	template-data
		);		
		
	}	

	public function show_info() 
	{
		// create links
		$support_link = "<a href='#'>NO Live-Support / FAQ</a>";	
		$readme_link = "<a href='http://cms-lab.com/_documentation/reset-pin/readme.php' class='ui basic button info' target='_blank'>Readme</a>";	

		// data for twig template engine	
		$data = array(
			'oRP'			=> $this,
			'readme_link'	=> $readme_link,		
			'SUPPORT'		=> $support_link,	
			'image_url'		=> 'http://cms-lab.com/_documentation/media/reset_pin/reset_pin.jpg'
			);

		/**	
		 *	get the template-engine.
		 */
		$oTwig = lib_twig_box::getInstance();
		$oTwig->registerModule('reset_pin');
			
		echo $oTwig->render( 
			"@reset_pin/info.lte",	//	template-filename
			$data						//	template-data
		);		
		
	}

	public function reset_value() 
	{
		
	if(isset ($_POST['username']) && $_POST['username'] != '') {
		$user_id = intval($_POST['username']);
	}
	elseif(isset ($_POST['display_name']) && $_POST['display_name'] != '') {
		$user_id = intval($_POST['display_name']);
	}
	else
	{
		header('Location: '.ADMIN_URL.'/logout/index.php');
	}
	
	$this->database->simple_query("UPDATE ".TABLE_PREFIX."users SET pin = '-1' WHERE user_id = ".$user_id." ");
	$this->database->simple_query("UPDATE ".TABLE_PREFIX."users SET pin_set = 0 WHERE user_id = ".$user_id." ");
	
	// Check if there is a db error, else success
	if($this->database->is_error()) {
		$this->admin->print_error($this->database->get_error());
		$this->admin->print_success($this->language['record_not_saved']);
	} else {
		$this->admin->print_success($this->language['record_saved'], $this->action_url);
	}	
	}		
	

} // end of class
?>